import os, time
from pathlib import Path
from flask import Blueprint, request, jsonify
from .ptb_adapter import process_update_sync

bp = Blueprint('routes', __name__)

_BASE_DIR = Path(__file__).resolve().parents[1]
_DEFAULT_LOG = _BASE_DIR / "tmp" / "app.log"
LOG_FILE = Path(os.environ.get("APP_LOG_FILE") or _DEFAULT_LOG)
try:
    LOG_FILE.parent.mkdir(parents=True, exist_ok=True)
except Exception:
    pass

def log(*args):
    try:
        with open(LOG_FILE, "a", encoding="utf-8") as f:
            f.write(time.strftime("[%Y-%m-%d %H:%M:%S] ") + " ".join(map(str,args)) + "\n")
    except Exception:
        pass

def token():
    return os.environ.get("BOT_TOKEN") or os.environ.get("TELEGRAM_BOT_TOKEN") or ""

@bp.get("/health")
def health():
    t = token()
    return jsonify(ok=True, has_token=bool(t), token_prefix=t[:12], mode="ptb_adapter")

@bp.post(f"/webhook/{os.environ.get('WEBHOOK_SECRET_PATH','qv_Secret_9kP27')}")
def webhook():
    t = token()
    if not t:
        log("ERR: BOT_TOKEN missing")
        return jsonify(ok=False, error="BOT_TOKEN missing"), 500
    update = request.get_json(silent=True) or {}
    try:
        process_update_sync(update, t)
    except Exception as e:
        log("EXC in process_update_sync:", repr(e))
    return jsonify(ok=True)
