from aiogram.types import ReplyKeyboardMarkup, KeyboardButton, InlineKeyboardMarkup, InlineKeyboardButton


def main_menu() -> ReplyKeyboardMarkup:
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="🔐 ورود مدیر هایپر")],
            [KeyboardButton(text="📮 درخواست خرید حساب")],
            [KeyboardButton(text="ℹ️ پشتیبانی"), KeyboardButton(text="📘 راهنما")],
        ],
        resize_keyboard=True,
    )


def hyper_admin_menu() -> ReplyKeyboardMarkup:
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="➕ ثبت مارکت جدید"), KeyboardButton(text="📂 مدیریت مارکت‌ها")],
            [KeyboardButton(text="⚙️ تنظیمات پایه"), KeyboardButton(text="↩️ خروج")],
        ],
        resize_keyboard=True,
    )


def register_input_keyboard(step_key: str) -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [InlineKeyboardButton(text="✏️ ارسال مقدار", callback_data=f"reg:input:{step_key}")],
            [
                InlineKeyboardButton(text="⬅️ بازگشت", callback_data="reg:back"),
                InlineKeyboardButton(text="❌ لغو", callback_data="reg:cancel"),
            ],
        ]
    )


def register_tier_keyboard() -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [
                InlineKeyboardButton(text="Base", callback_data="reg:tier:base"),
                InlineKeyboardButton(text="Silver", callback_data="reg:tier:silver"),
                InlineKeyboardButton(text="Gold", callback_data="reg:tier:gold"),
            ],
            [
                InlineKeyboardButton(text="⬅️ بازگشت", callback_data="reg:back"),
                InlineKeyboardButton(text="❌ لغو", callback_data="reg:cancel"),
            ],
        ]
    )


def register_confirm_keyboard() -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [InlineKeyboardButton(text="✅ تایید نهایی", callback_data="reg:confirm")],
            [
                InlineKeyboardButton(text="⬅️ بازگشت", callback_data="reg:back"),
                InlineKeyboardButton(text="❌ لغو", callback_data="reg:cancel"),
            ],
        ]
    )


STATUS_LABEL = {"active": "فعال", "inactive": "غیرفعال"}


def tenants_keyboard(tenants: list[dict]) -> InlineKeyboardMarkup:
    rows = []
    for t in tenants:
        status = STATUS_LABEL.get(t.get("status"), "نامشخص")
        rows.append(
            [
                InlineKeyboardButton(
                    text=f"{t['title']} ({t['code']}) · {status}",
                    callback_data=f"tenant:{t['id']}",
                )
            ]
        )
    rows.append([InlineKeyboardButton(text="⬅️ بازگشت", callback_data="tenant:back")])
    return InlineKeyboardMarkup(inline_keyboard=rows)


def tenant_actions_keyboard(tenant_id: str, is_active: bool) -> InlineKeyboardMarkup:
    rows = [
        [
            InlineKeyboardButton(
                text=("⏸️ غیرفعال‌سازی" if is_active else "▶️ فعال‌سازی"),
                callback_data=f"tact:toggle:{tenant_id}",
            )
        ],
        [InlineKeyboardButton(text="👤 افزودن مدیر", callback_data=f"tact:add_admin:{tenant_id}")],
        [InlineKeyboardButton(text="📝 ویرایش پروفایل", callback_data=f"tact:edit_profile:{tenant_id}")],
        [InlineKeyboardButton(text="📣 ارسال اعلان", callback_data=f"tact:notify:{tenant_id}")],
        [InlineKeyboardButton(text="⬅️ بازگشت", callback_data="tenant:list")],
        [InlineKeyboardButton(text="❌ لغو", callback_data="tenant:cancel")],
    ]
    return InlineKeyboardMarkup(inline_keyboard=rows)
