from __future__ import annotations
from typing import List, Optional
from pydantic import BaseModel, UUID4


class SpecIn(BaseModel):
    name: str
    values: str


class ProductImageIn(BaseModel):
    telegram_file_id: str
    sort_order: int = 0


class ProductCreate(BaseModel):
    sku: str
    title: str
    name: Optional[str]
    description: Optional[str]
    base_price: float
    discount_percent: Optional[int] = 0
    image_file_id: Optional[str]
    stock: int = 0
    active: bool = True
    categories: List[UUID4] = []
    specs: List[SpecIn] = []
    images: List[ProductImageIn] = []


class ProductUpdate(BaseModel):
    title: Optional[str]
    name: Optional[str]
    description: Optional[str]
    base_price: Optional[float]
    discount_percent: Optional[int]
    image_file_id: Optional[str]
    stock: Optional[int]
    active: Optional[bool]
    categories: Optional[List[UUID4]]
    specs: Optional[List[SpecIn]]


class ProductOut(BaseModel):
    id: UUID4
    sku: str
    title: str
    base_price: float
    current_price: float
    discount_percent: int
    active: bool
    stock: int
    image_file_id: Optional[str]
    specs: List[SpecIn]
    categories: List[UUID4]
    images: List[str]
