uvicorn app.main:app --reload 
alembic upgrade head
.env حاوی حداقل این مقادیر باشد:
HYPER_BOT_TOKEN
STORE_BOT_TOKEN
STORE_TENANT_ID (برای مارکت تست)
STORE_CHANNEL_URL
HYPER_ADMIN_TELEGRAM_IDS شامل آی‌دی اکانتی که می‌خواهید با آن Hyper Bot را کنترل کنید.
اگر در محیط توسعه Bot واقعی ندارید و صرفاً می‌خواهید ثبت مارکت تستی بگیرید، موقتاً TELEGRAM_VERIFY_TOKENS=false.
2. Hyper Bot
python -m app.bots.hyper.main

HYPER_ADMIN_TELEGRAM_IDS
python -m app.bots.store.main 


# Hyper Store Platform

سیستم «Hyper Store» یک بستر کامل برای مدیریت مارکت‌های تلگرامی است که دو ربات اصلی دارد:

- **Hyper Bot**: مخصوص تیم مرکزی برای ثبت مارکت‌ها، مدیریت کانال و مدیران فروشگاه.
- **Store Bot**: برای مدیران هر مارکت و مشتریان آن (مدیریت محصول، سفارش و تجربه‌ی خرید).

Backend با FastAPI پیاده‌سازی شده، دیتابیس PostgreSQL است و منطق Automation (ثبت مارکت، لایک، سبد خرید و …) توسط ربات‌ها انجام می‌شود.

---

## فهرست مطالب
1. [معماری و اجزاء](#architecture)
2. [پیش‌نیازها](#prerequisites)
3. [راه‌اندازی Backend](#backend-setup)
4. [متغیرهای محیطی](#env-vars)
5. [اجرای ربات‌ها](#bots)
6. [جریان‌های اصلی](#flows)
7. [لاگ‌ها و اشکال‌زدایی](#logs)
8. [نکات امنیتی و تست](#security)
9. [منابع و مستندات تکمیلی](#docs)

--- 

## 1. معماری و اجزاء <a name="architecture"></a>

```
docs/                    سناریوها و نیازمندی‌ها (docs/bot_spec.md)
app/
  core/                  تنظیمات، لاگ، کانتکست
  models/                مدل‌های SQLAlchemy
  services/              منطق دامنه (tenant, visits, …)
  api/routers/           FastAPI routers (auth, tenants, products, visits, ...)
  bots/
    hyper/               ربات Hyper (aiogram)
    store/               ربات Store (ادمین + مشتری)
  migrations/            اسکریپت‌های Alembic
logs/
  hyper_bot/             لاگ Hyper Bot
  store_bot/             لاگ Store Bot
```

- **Channel Integration:** هر فروشگاه کانال اختصاصی دارد؛ مشتری از طریق Store Bot وارد کانال می‌شود، محصولات را لایک می‌کند و پس از «پایان بازدید» فهرست لایک‌ها به ربات بازمی‌گردد.
- **Session Tracking:** جدول‌های `store_visit` و `product_like` نشست کانال و لایک‌ها را ثبت می‌کنند (API `/visits`).  
- **مرجع طراحی:** سناریوهای دقیق در [docs/bot_spec.md](docs/bot_spec.md).

---

## 2. پیش‌نیازها <a name="prerequisites"></a>

- Python 3.11
- PostgreSQL 14+
- BotFather tokens برای Hyper Bot و Store Bot (و در حالت واقعی، توکن اختصاصی برای هر مارکت)
- دسترسی به کانال تلگرام به‌عنوان **Admin**

---

## 3. راه‌اندازی Backend <a name="backend-setup"></a>

```bash
git clone <repo>
cd hyper_store_final
python -m venv .venv
.venv/Scripts/activate           # در Windows
pip install -r requirements.txt
```

فایل `.env` را بسازید (جزئیات در بخش بعد). سپس دیتابیس را آماده کنید:

```bash
.venv/Scripts/activate
alembic upgrade head             # ایجاد جداول و seed اولیه
uvicorn app.main:app --reload    # اجرای API
```

برای پاک‌سازی و ساخت مجدد DB می‌توانید از اسکریپت ساده استفاده کنید:

```bash
python - <<'PY'
from app.db.base import Base
from app.db.session import engine
Base.metadata.drop_all(bind=engine)
Base.metadata.create_all(bind=engine)
PY
```

---

## 4. متغیرهای محیطی <a name="env-vars"></a>

نمونه‌ی کامل در [.env.example](.env.example) قرار دارد؛ مهم‌ترین موارد:

| کلید | توضیح |
| ---- | ----- |
| `DB_DSN` | اتصال PostgreSQL |
| `JWT_SECRET`, `JWT_ALG`, `JWT_EXP_MIN` | احراز هویت API |
| `API_BASE_URL` | آدرس backend (برای ربات‌ها) |
| `PROXY_URL` | در صورت نیاز به Socks5 برای اتصال تلگرام |
| `HYPER_BOT_TOKEN` | توکن Bot مادر |
| `STORE_BOT_TOKEN` | توکن Bot فروشگاه مرکزی |
| `STORE_TENANT_ID` | شناسه‌ی فروشگاهی که Store Bot باید پیش‌فرض به آن وصل شود |
| `STORE_CHANNEL_URL` | لینک کانال عمومی فروشگاه (برای مشتری) |
| `DEFAULT_HYPER_ADMIN_USERNAME/PASSWORD` | credential اولیه‌ی Hyper Admin |
| `HYPER_ADMIN_TELEGRAM_IDS` | لیست آی‌دی‌های تلگرام که مجاز به استفاده از Hyper Bot هستند (جداشده با `,`) |
| `TELEGRAM_VERIFY_TOKENS` | اگر `true` باشد، در ایجاد مارکت جدید توکن Bot با `getMe` اعتبارسنجی می‌شود |

> **نکات مهم:**  
> - Hyper Bot فقط به user id هایی که در `HYPER_ADMIN_TELEGRAM_IDS` آمده‌اند اجازه‌ی ورود می‌دهد.  
> - برای محیط توسعه می‌توانید `TELEGRAM_VERIFY_TOKENS=false` بگذارید تا بدون Bot واقعی تست کنید (در تولید حتماً `true`).  
> - هر مارکت توکن Bot و channel_id اختصاصی خودش را دارد؛ توکن تکراری باعث خطای 400 می‌شود.

---

## 5. اجرای ربات‌ها <a name="bots"></a>

### Hyper Bot
```bash
.venv/Scripts/activate
python -m app.bots.hyper.main
```
- فقط اکانت‌های موجود در `HYPER_ADMIN_TELEGRAM_IDS` می‌توانند وارد شوند.
- پس از ورود، منوی اصلی شامل «ثبت مارکت جدید»، «مدیریت مارکت‌ها»، «تنظیمات پایه» و «خروج» است.
- ویزارد ثبت مارکت تماماً دکمه‌ای است؛ هر مرحله گزینه‌های «بازگشت» و «لغو» دارد و در پایان پیش‌نمایش نمایش داده می‌شود.

### Store Bot
```bash
.venv/Scripts/activate
python -m app.bots.store.main
```
- **مدیر مارکت** با دکمه «مدیریت مارکت» وارد می‌شود؛ داشبورد شامل محصولات، دسته‌بندی‌ها، سفارش‌ها و کانال است.
- **مشتری** با «ورود به فروشگاه» منوی Inline دریافت می‌کند: ورود به کانال، مشاهده‌ی دسته‌ها، ورود سریع و سبد خرید.
- هنگام ورود به کانال، یک Session جدید ایجاد می‌شود و دکمه‌ی «پایان بازدید» فعال می‌گردد؛ با پایان بازدید، لیست محصولات لایک‌شده بر اساس API `/visits` نمایش داده می‌شود و مشتری می‌تواند آن‌ها را به سبد یا سفارش نهایی تبدیل کند.

> هر دو ربات از aiogram 3 استفاده می‌کنند؛ برای ارسال دستور خروج (cancel) در ویزاردها می‌توانید از `/cancel` استفاده کنید.

---

## 6. جریان‌های اصلی <a name="flows"></a>

### Hyper Admin
1. ورود → پیام «در حال ورود…» + منوی محدود به Admin IDs.  
2. **ثبت مارکت جدید** → ویزارد چندمرحله‌ای (عنوان، موبایل، آدرس، دسته، توکن Bot، channel_id، لینک دعوت، ساعات، اشتراک).  
3. تایید نهایی → ایجاد tenant، ذخیره‌ی channel info در profile و نمایش credential مدیر فروشگاه.  
4. **مدیریت مارکت‌ها** → لیست مارکت‌های غیر hyper؛ انتخاب هر مارکت خلاصه‌ی وضعیت + دکمه‌های عملیاتی (فعال/غیرفعال، افزودن مدیر، ویرایش پروفایل، ارسال اعلان).  
5. تمام عملیات مهم در `logs/hyper_bot/hyper.log` ثبت می‌شود (JSON).

### Store Admin
1. ورود با نام‌کاربری/رمز → منوی Reply (محصولات، دسته‌ها، سفارش‌ها، کانال).  
2. **محصولات** → دکمه «ثبت محصول جدید» (ویزارد دکمه‌ای) + لیست محصولات فعال/غیرفعال.  
3. **دسته‌بندی‌ها** → افزودن، لیست‌گیری (سایر عملیات در حال توسعه).  
4. **کانال** → ذخیره channel_id و لینک دعوت، انتشار تستی (در حال توسعه).  
5. **سفارش‌ها** → مشاهده‌ی سفارش‌های ذخیره شده و پرداخت‌شده.  
6. تمامی عملیات در `logs/store_bot/store.log` لاگ می‌شوند.

#### فرآیند ثبت/ویرایش محصول و انتشار کانال (وضعیت فعلی)
- ویزارد «ثبت محصول جدید» شش مرحله دارد: عنوان، توضیح، قیمت پایه، درصد تخفیف، موجودی و تصویر (file_id). هر گام با دکمه‌های «بازگشت» و «لغو» قابل کنترل است و اعتبارسنجی عددی روی قیمت/موجودی انجام می‌شود.
- پس از تایید، ربات محتوای ویزارد را با بدنه‌ی زیر به API `/products` ارسال می‌کند و `sku` مستقیماً از عنوان (trim + حداکثر ۱۶ کاراکتر) ساخته می‌شود. در حال حاضر دسته‌بندی و مشخصات خالی ارسال می‌گردد و امکان انتخاب چند تصویر وجود ندارد.
- دکمه‌های «محصولات فعال/غیرفعال» تنها لیست متنی (۲۰ مورد اول) را نمایش می‌دهند و هیچ مسیر FSM برای ویرایش، غیرفعال/فعال‌سازی یا حذف وجود ندارد. هرگونه ویرایش باید از طریق پنل/API بک‌اند انجام و سپس با دکمه «لیست» مجدد بررسی شود.
- برای انتشار کانالی، مدیر فقط می‌تواند `channel_id` و لینک دعوت را ذخیره کند و دکمه «ارسال تست» یک پیام ساده (`send_message`) به همان کانال می‌فرستد. هیچ سازوکار خودکاری برای تولید پست محصول از روی داده‌های ثبت‌شده یا زمان‌بندی ارسال وجود ندارد.
- لینک ورود مشتری به کانال از متغیر محیطی `STORE_CHANNEL_URL` خوانده می‌شود (ثابت در سطح استقرار) و هنوز به پروفایل هر مارکت متصل نیست؛ بنابراین برای چند مارکت باید به‌صورت دستی این مقدار را تغییر دهید یا منطق تازه‌ای اضافه کنید.
- برای تکمیل چرخه «ثبت → انتشار»، لازم است ویژگی‌های زیر در آینده اضافه شود: بارگذاری دسته‌بندی در ویزارد، صفحه جزئیات محصول با دکمه «ویرایش»، تولید کپشن/دکمه‌های پست و صف انتشار به کانال (با استفاده از `channel_id` ذخیره‌شده).

### مشتری فروشگاه
1. دکمه «ورود به فروشگاه» → منوی Inline با گزینه‌های ورود به کانال، مشاهده‌ی دسته‌ها، ورود سریع و سبد خرید.  
2. «ورود به کانال» → Session جدید ثبت می‌شود، لینک کانال ارسال و دکمه‌ی «پایان بازدید» فعال می‌شود.  
3. مشتری محصولات را در کانال لایک می‌کند؛ پس از کلیک روی «پایان بازدید»، لیست لایک‌ها (از `/visits/.../likes`) به ربات ارسال می‌شود و مشتری می‌تواند تعداد هر محصول را ویرایش، حذف یا به سبد اضافه کند.  
4. Checkout: ورود سریع با تلگرام، جمع‌آوری اطلاعات تماس/آدرس (در دست توسعه) و ثبت سفارش از طریق API `/cart/checkout`.  

---

## 7. لاگ‌ها و اشکال‌زدایی <a name="logs"></a>

| محل | توضیح |
|-----|-------|
| `logs/hyper_bot/hyper.log` | لاگ JSON مربوط به Hyper Bot (ورود، ثبت مارکت، خطاها) |
| `logs/store_bot/store.log` | لاگ JSON مربوط به Store Bot (ورود مدیر، عملیات مشتری) |
| Console | همچنان برای توسعه فعال است (LOG_LEVEL از `.env` خوانده می‌شود) |

برای اشکال‌زدایی سریع ربات‌ها:
```bash
tail -f logs/hyper_bot/hyper.log
tail -f logs/store_bot/store.log
```

---

## 8. نکات امنیتی و تست <a name="security"></a>

- **محدودسازی Hyper Bot:** آی‌دی تلگرام مدیران مجاز را در `HYPER_ADMIN_TELEGRAM_IDS` قرار دهید.  
- **توکن Bot**: هر مارکت باید Bot اختصاصی داشته باشد؛ توکن مشترک باعث خطا می‌شود.  
- **تلگرام Verify:** در تولید `TELEGRAM_VERIFY_TOKENS=true` نگه دارید تا Botهایی که وجود ندارند ثبت نشوند.  
- **اطلاعات مشتری**: در مرحله‌ی Checkout باید داده‌های حساس (تلفن، آدرس) را رمزنگاری یا حداقل Hash کنید (در آینده).  
- **تست**: پس از هر تغییر، سناریوهای زیر را اجرا کنید:
  1. ساخت مارکت جدید با Hyper Bot (با Bot Token واقعی)
  2. ورود مدیر مارکت، ثبت محصول، ایجاد دسته و مشاهده سفارش
  3. ورود مشتری → کانال → لایک → پایان بازدید → نهایی‌سازی سفارش
  4. بررسی لاگ‌ها برای خطاهای احتمالی

---

## 9. مستندات تکمیلی <a name="docs"></a>

- [docs/bot_spec.md](docs/bot_spec.md) – شرح کامل نیازمندی‌ها، منوها و جریان‌ها
- `app/services/store_visits.py` و `app/api/routers/visits.py` – منطق نشست کانال و API لایک‌ها
- فایل‌های ربات (`app/bots/...`) – پیاده‌سازی aiogram برای Hyper و Store

برای درخواست ویژگی جدید یا گزارش باگ، لطفاً سناریوهای دقیق و خروجی لاگ مربوطه را ضمیمه کنید. موفق باشید! 🙌
