from __future__ import annotations
from sqlalchemy.orm import Session
from sqlalchemy import select
from app.models import Payment, Order
from app.schemas.order import PaymentStatusUpdate


def register_payment(db: Session, order: Order, amount: float | None, method: str) -> Payment:
    payment = Payment(
        tenant_id=order.tenant_id,
        order_id=order.id,
        amount=amount if amount is not None else order.total,
        method=method,
    )
    order.payments.append(payment)
    db.add(order)
    db.commit()
    db.refresh(payment)
    db.refresh(order)
    return payment


def update_payment_status(db: Session, payment: Payment, payload: PaymentStatusUpdate) -> Payment:
    payment.status = payload.status
    payment.gateway_tx_id = payload.gateway_tx_id or payment.gateway_tx_id
    payment.card2card_note = payload.card2card_note or payment.card2card_note
    order = payment.order
    if payload.status == "confirmed":
        order.status = "paid"
    elif payload.status == "failed":
        order.status = "canceled"
    db.add(order)
    db.add(payment)
    db.commit()
    db.refresh(payment)
    return payment


def get_payment(db: Session, payment_id: str) -> Payment | None:
    return db.get(Payment, payment_id)


def list_payments(db: Session, order_id: str) -> list[Payment]:
    stmt = select(Payment).where(Payment.order_id == order_id)
    return list(db.scalars(stmt))
