from __future__ import annotations
from datetime import datetime
from pydantic import BaseModel, Field, UUID4
from typing import Optional


class APIModel(BaseModel):
    class Config:
        orm_mode = True


class MessageResponse(APIModel):
    message: str


class TenantScoped(APIModel):
    tenant_id: UUID4 = Field(..., alias="tenantId")


class Timestamped(APIModel):
    created_at: datetime
    updated_at: datetime
