from __future__ import annotations
from datetime import datetime
from typing import Optional
from pydantic import BaseModel, UUID4


class VisitStartRequest(BaseModel):
    telegram_user_id: int


class VisitCompleteRequest(BaseModel):
    status: str = "completed"


class VisitOut(BaseModel):
    id: UUID4
    session_token: str
    status: str
    started_at: datetime
    ended_at: Optional[datetime]


class LikeCreate(BaseModel):
    product_id: UUID4
    telegram_user_id: int
    session_token: Optional[str]


class LikeOut(BaseModel):
    id: UUID4
    product_id: UUID4
    telegram_user_id: int
    liked_at: datetime
    session_id: Optional[UUID4]
