from __future__ import annotations
from datetime import datetime
from sqlalchemy.orm import Session
from sqlalchemy import select, func
from app.models import Order
from app.schemas.report import ReportFilters, OrdersReport, OrderReportRow


def build_orders_report(db: Session, tenant_id: str, filters: ReportFilters) -> OrdersReport:
    stmt = (
        select(Order)
        .where(
            Order.tenant_id == tenant_id,
            Order.created_at >= filters.date_from,
            Order.created_at <= filters.date_to,
        )
        .order_by(Order.created_at)
    )
    rows = []
    total = 0.0
    for order in db.scalars(stmt):
        rows.append(
            OrderReportRow(
                order_id=str(order.id),
                total=float(order.total),
                status=order.status,
                payment_method=order.payment_method,
                created_at=order.created_at,
            )
        )
        total += float(order.total)
    return OrdersReport(rows=rows, total_amount=total)
