# ~/public_html/AllBots/Bazarya/passenger_wsgi.py
import os, sys
from pathlib import Path
from asgiref.wsgi import AsgiToWsgi
from dotenv import load_dotenv

BASE_DIR = Path(__file__).resolve().parent
sys.path.insert(0, str(BASE_DIR))
os.chdir(BASE_DIR)

load_dotenv(BASE_DIR / ".env")  # در صورت تمایل می‌توانید از PassengerEnvVar هم استفاده کنید

from app.main import app as fastapi_app  # همان FastAPI اصلی
application = AsgiToWsgi(fastapi_app)


from a2wsgi import ASGIMiddleware
from app.main import app   # این همان FastAPI است که در app/main.py تعریف شده

# این آبجکت را هاست به عنوان WSGI application صدا می‌زند
application = ASGIMiddleware(app)
