from __future__ import annotations
from typing import Optional, List
from pydantic import BaseModel, UUID4


class CartItemIn(BaseModel):
    product_id: UUID4
    qty: int = 1
    chosen_specs: Optional[dict]


class CartItemOut(BaseModel):
    id: UUID4
    product_id: UUID4
    qty: int
    final_price_snapshot: float


class OrderOut(BaseModel):
    id: UUID4
    status: str
    total: float
    items: List[CartItemOut]


class CheckoutRequest(BaseModel):
    payment_method: str


class PaymentStatusUpdate(BaseModel):
    status: str
    gateway_tx_id: Optional[str]
    card2card_note: Optional[str]
