from sqlalchemy.orm import Session
from app.models import AuditLog


def log_action(db: Session, tenant_id: str | None, actor_id: str | None, action: str, payload: dict | None = None) -> None:
    entry = AuditLog(tenant_id=tenant_id, actor_user_id=actor_id, action=action, payload=payload)
    db.add(entry)
    db.commit()
