from aiogram.fsm.state import StatesGroup, State


class StoreLoginStates(StatesGroup):
    username = State()
    password = State()
    admin_menu = State()


class AdminMenuStates(StatesGroup):
    main = State()


class AdminFlowStates(StatesGroup):
    section = State()
    wizard = State()
    awaiting_input = State()


class ProductWizardStates(StatesGroup):
    flow = State()
    awaiting_value = State()
    confirm = State()


class CategoryWizardStates(StatesGroup):
    awaiting_name = State()
    managing = State()


class OrderStates(StatesGroup):
    viewing = State()


class ChannelStates(StatesGroup):
    awaiting_channel_id = State()
    awaiting_invite = State()


class AdminSettingsStates(StatesGroup):
    waiting_manager_ids = State()
    waiting_payment_template = State()
    waiting_payment_note = State()


class CustomerFlowStates(StatesGroup):
    menu = State()
    browsing = State()
    products = State()
    cart = State()
    checkout = State()
    awaiting_cart_quantity = State()
    waiting_receipt = State()


class CustomerSearchStates(StatesGroup):
    waiting_term = State()


class CustomerAccountStates(StatesGroup):
    menu = State()
    login_contact = State()
    login_password = State()
    register_contact = State()
    register_first = State()
    register_last = State()
    register_address = State()
    register_postal = State()
    register_location = State()
    register_password = State()
