from functools import lru_cache
from pydantic import Field
from pydantic_settings import BaseSettings, SettingsConfigDict


class Settings(BaseSettings):
    DB_DSN: str = Field(..., description="SQLAlchemy-compatible DSN")
    JWT_SECRET: str = Field(..., min_length=16)
    JWT_ALG: str = "HS256"
    JWT_EXP_MIN: int = 60
    TELEGRAM_API_BASE: str = "https://api.telegram.org"
    API_BASE_URL: str = "http://localhost:8000"
    PROXY_URL: str | None = None
    HYPER_BOT_TOKEN: str | None = None
    STORE_BOT_TOKEN: str | None = None
    STORE_TENANT_ID: str | None = None
    STORE_CHANNEL_URL: str | None = None
    STORE_BOT_USERNAME: str | None = None
    HYPER_ADMIN_TELEGRAM_IDS: str | None = None
    DEFAULT_HYPER_ADMIN_USERNAME: str = "hyperadmin"
    DEFAULT_HYPER_ADMIN_PASSWORD: str = "supersecret"
    TELEGRAM_VERIFY_TOKENS: bool = True
    LOG_LEVEL: str = "INFO"
    ACCOUNT_PURCHASE_AMOUNT: int | None = None
    ZARINPAL_MERCHANT_ID: str | None = None
    ZARINPAL_CALLBACK_URL: str | None = None
    ZARINPAL_SANDBOX: bool = False

    model_config = SettingsConfigDict(
        env_file=".env",
        env_file_encoding="utf-8",
        case_sensitive=False,
    )


@lru_cache(maxsize=1)
def get_settings() -> Settings:
    return Settings()
