from alembic import op
import sqlalchemy as sa

from app.db.types import GUID


TABLE_KWARGS = {"mysql_engine": "InnoDB", "mysql_charset": "utf8mb4"}


revision = "0004_price_history"
down_revision = "0003_sales"
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        "product_price_history",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("product_id", GUID(), sa.ForeignKey("product.id", ondelete="CASCADE"), nullable=False),
        sa.Column("base_price", sa.Numeric(12, 2), nullable=False),
        sa.Column("discount_percent", sa.Integer(), nullable=False, server_default="0"),
        sa.Column("effective_from", sa.TIMESTAMP(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        sa.Column("effective_to", sa.TIMESTAMP(timezone=True)),
        sa.CheckConstraint("base_price >= 0"),
        sa.CheckConstraint("discount_percent BETWEEN 0 AND 90"),
        **TABLE_KWARGS,
    )
    op.create_index("idx_pph_product_from", "product_price_history", ["product_id", "effective_from"])


def downgrade():
    op.drop_index("idx_pph_product_from", table_name="product_price_history")
    op.drop_table("product_price_history")
