from sqlalchemy.orm import Session
from app.models import AccountRequest


def create_account_request(db: Session, full_name: str, phone: str, description: str | None) -> AccountRequest:
    lead = AccountRequest(full_name=full_name, phone=phone, description=description)
    db.add(lead)
    db.commit()
    db.refresh(lead)
    return lead
